

<?php
session_start();
include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে
$userId = $_SESSION['user_id'];


$isAdmin = ($_SESSION['role'] == 'admin');

?>


<?php
require('vendor-barcode/autoload.php');
require('pdf/fpdf.php');

use Picqer\Barcode\BarcodeGeneratorPNG;

$con->set_charset("utf8mb4");

$search = $_GET['search'] ?? '';
if (!$search) die("Please provide a Product ID, e.g. ?search=2503");

$stmt = $con->prepare("SELECT Product_id AS id, name AS product_name FROM product WHERE Product_id = ?");
$stmt->bind_param("s", $search);
$stmt->execute();
$products = $stmt->get_result();

if ($products->num_rows === 0) die("No product found for Product ID: " . htmlspecialchars($search));

$product = $products->fetch_assoc();

$pdf = new FPDF('P','mm','A4');
$pdf->AddPage();
$pdf->SetMargins(10,10,10);

// **ফন্ট সেট করুন**
$pdf->SetFont('Arial','',10);

$generator = new BarcodeGeneratorPNG();

$col = 0;
$row = 0;
$labelWidth = 60;
$labelHeight = 40;
$labelsPerRow = 3;
$labelsPerPage = 18;

for($i=0;$i<$labelsPerPage;$i++){
    $barcodeData = $generator->getBarcode($product['id'],$generator::TYPE_CODE_128);
    $tempBarcode = tempnam(sys_get_temp_dir(),'barcode').'.png';
    file_put_contents($tempBarcode,$barcodeData);

    $x = 10 + ($col * $labelWidth);
    $y = 10 + ($row * $labelHeight);

    $pdf->SetXY($x,$y);
    $pdf->Cell($labelWidth,6,$product['product_name'],0,2,'C');
    $pdf->Image($tempBarcode,$x+10,$y+10,40,12);
    $pdf->SetXY($x,$y+25);
    $pdf->Cell($labelWidth,6,"ID: ".$product['id'],0,0,'C');

    unlink($tempBarcode);

    $col++;
    if($col >= $labelsPerRow){
        $col=0;
        $row++;
    }
}
/*   
http://localhost/bbe.com/Rubel/barcode_labels.php?search=2503----*/

$pdf->Output();
