<?php
include 'php/db_connection.php';

$product_id = $_GET['product_id'] ?? '';

if ($product_id) {
    // সব প্রোডাক্ট স্ক্যান হবে, শুধু cancelled বাদ
    $stmt = $con->prepare("SELECT name as description, price, purchase_price, 
                          COALESCE(SUM(Quantity), 0) as available_quantity 
                          FROM product 
                          WHERE Product_id = ? AND status != 'cancelled'
                          AND (Expiration_date IS NULL OR Expiration_date = '' OR Expiration_date >= CURDATE())
                          GROUP BY Product_id");
    $stmt->bind_param("s", $product_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($row = $result->fetch_assoc()) {
        echo json_encode($row);
    } else {
        echo json_encode(['available_quantity' => 0, 'description' => 'Product not found', 'price' => 0, 'purchase_price' => 0]);
    }
} else {
    echo json_encode(['available_quantity' => 0, 'description' => 'Invalid product ID', 'price' => 0, 'purchase_price' => 0]);
}
?>