<?php
session_start();
include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role'];
$isAdmin = ($_SESSION['role'] == 'admin');

// Check if ID is provided
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "<script>alert('No product ID provided!'); window.location.href='add_product_name.php';</script>";
    exit();
}

$Product_id = intval($_GET['id']);

// Fetch product details first to get the Product_id for redirect
$stmt = $con->prepare("SELECT * FROM product WHERE id = ?");
$stmt->bind_param("i", $Product_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    echo "<script>alert('Product not found!'); window.location.href='add_product_name.php';</script>";
    exit();
}

$product = $result->fetch_assoc();
$category_id = $product['Product_id'];
$product_name = $product['name'];
$product_Quantity = $product['Quantity'];
$product_price = $product['price'];
$stmt->close();

// Handle confirmation
if (isset($_POST['confirm_delete'])) {
    // Check if product is used in any sales
    $check_sales = $con->prepare("SELECT COUNT(*) as count FROM sales_items WHERE Product_id = ?");
    $check_sales->bind_param("i", $category_id);
    $check_sales->execute();
    $sales_result = $check_sales->get_result();
    $sales_data = $sales_result->fetch_assoc();
    
    if ($sales_data['count'] > 0) {
        echo "<script>
            alert('Cannot delete this product! It has been used in {$sales_data['count']} sales transaction(s).');
            window.location.href='add_product.php?category={$category_id}';
        </script>";
        exit();
    }
    $check_sales->close();
    
    // Delete the product
    $delete_stmt = $con->prepare("DELETE FROM product WHERE id = ?");
    $delete_stmt->bind_param("i", $Product_id);
    
    if ($delete_stmt->execute()) {
        echo "<script>
            alert('Product deleted successfully!');
            window.location.href='add_product.php?category={$category_id}';
        </script>";
        exit();
    } else {
        echo "<script>
            alert('Failed to delete product!');
            window.location.href='add_product.php?category={$category_id}';
        </script>";
        exit();
    }
    $delete_stmt->close();
}

// Handle cancel
if (isset($_POST['cancel_delete'])) {
    header("Location: add_product.php?category={$category_id}");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delete Product - Confirmation</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        

        .delete-container {
            background: white;
            padding: 50px;
            border-radius: 16px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 600px;
            width: 100%;
            text-align: center;
            animation: slideIn 0.4s ease-out;
        }

        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(-30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .warning-icon {
            font-size: 80px;
            margin-bottom: 20px;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.15);
            }
        }

        h1 {
            color: #dc3545;
            margin-bottom: 15px;
            font-size: 32px;
            font-weight: bold;
        }

        .warning-text {
            font-size: 20px;
            color: #333;
            margin-bottom: 30px;
            font-weight: 500;
        }

        .product-details {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            padding: 25px;
            border-radius: 12px;
            margin: 25px 0;
            text-align: left;
            border: 2px solid #dee2e6;
        }

        .product-details h3 {
            color: #495057;
            margin-bottom: 15px;
            font-size: 18px;
            text-align: center;
            border-bottom: 2px solid #adb5bd;
            padding-bottom: 10px;
        }

        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #dee2e6;
        }

        .detail-row:last-child {
            border-bottom: none;
        }

        .detail-label {
            font-weight: bold;
            color: #495057;
        }

        .detail-value {
            color: #212529;
        }

        .danger-alert {
            background-color: #f8d7da;
            border: 2px solid #f5c6cb;
            color: #721c24;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            font-weight: bold;
            font-size: 16px;
        }

        .button-group {
            display: flex;
            gap: 15px;
            margin-top: 30px;
        }

        .btn-delete {
            flex: 1;
            background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
            color: white;
            padding: 16px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 18px;
            font-weight: bold;
            transition: all 0.3s;
            box-shadow: 0 4px 15px rgba(220, 53, 69, 0.3);
        }

        .btn-delete:hover {
            background: linear-gradient(135deg, #c82333 0%, #bd2130 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(220, 53, 69, 0.4);
        }

        .btn-cancel {
            flex: 1;
            background: linear-gradient(135deg, #6c757d 0%, #5a6268 100%);
            color: white;
            padding: 16px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 18px;
            font-weight: bold;
            transition: all 0.3s;
            box-shadow: 0 4px 15px rgba(108, 117, 125, 0.3);
        }

        .btn-cancel:hover {
            background: linear-gradient(135deg, #5a6268 0%, #545b62 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(108, 117, 125, 0.4);
        }

        @media (max-width: 768px) {
            .delete-container {
                padding: 30px 20px;
            }

            .button-group {
                flex-direction: column;
            }

            h1 {
                font-size: 26px;
            }

            .warning-text {
                font-size: 18px;
            }
        }
    </style>
</head>
<body>
     <?php include 'sidebar.php'; ?>
     
    <div class="delete-container">
        <div class="warning-icon">⚠️</div>
        
        <h1>Delete Product?</h1>
        
        <p class="warning-text">Are you sure you want to permanently delete this product?</p>
        
        <div class="product-details">
            <h3>📦 Product Information</h3>
            <div class="detail-row">
                <span class="detail-label">Product Name:</span>
                <span class="detail-value"><?php echo htmlspecialchars($product_name); ?></span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Product ID:</span>
                <span class="detail-value"><?php echo htmlspecialchars($category_id); ?></span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Quantity:</span>
                <span class="detail-value"><?php echo htmlspecialchars($product_Quantity); ?></span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Price:</span>
                <span class="detail-value">৳<?php echo number_format($product_price, 2); ?></span>
            </div>
        </div>
        
        <div class="danger-alert">
            🚨 This action cannot be undone!
        </div>
        
        <form method="POST">
            <div class="button-group">
                <button type="submit" name="confirm_delete" class="btn-delete">
                    🗑️ Yes, Delete Product
                </button>
                <button type="submit" name="cancel_delete" class="btn-cancel">
                    ← No, Keep Product
                </button>
            </div>
        </form>
    </div>
</body>
</html>

<?php
$con->close();
?>