<?php
include 'php/db_connection.php';
session_start();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Return Process</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body class="p-4">
<?php include 'sidebar.php'; ?>
<h3>Return Products</h3>

<!-- Button to Open Modal -->
<button type="button" class="btn btn-primary mb-3" data-toggle="modal" data-target="#returnModal">
    Create Return
</button>

<!-- ===================== Modal ===================== -->
<div class="modal fade" id="returnModal" tabindex="-1" role="dialog" aria-labelledby="returnModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Return Product</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">

        <!-- Search Invoice -->
        <form id="returnForm" method="post">
            <div class="form-inline mb-3">
                <input type="text" name="invoice_id" id="invoice_id" class="form-control mr-2" placeholder="Enter Invoice ID" required>
                <button type="button" id="searchInvoice" class="btn btn-primary">Search</button>
            </div>

            <!-- Products Table -->
            <div id="invoiceProducts"></div>

            <button type="submit" name="process_return" class="btn btn-success mt-3">Submit Return</button>
        </form>

      </div>
    </div>
  </div>
</div>
<!-- ===================== End Modal ===================== -->

<hr>

<h4>All Returns</h4>
<table class="table table-bordered">
    <thead>
        <tr>
            <th>ID</th>
            <th>Invoice</th>
            <th>Product</th>
            <th>Qty</th>
            <th>Refund Amount</th>
            <th>Reason</th>
            <th>Notes</th>
            <th>Status</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $returns = $con->query("
            SELECT ri.id, ri.invoice_id, p.name, ri.return_quantity, ri.refund_amount, ri.reason, ri.notes, ri.status
            FROM return_items ri
            JOIN product p ON ri.product_id = p.Product_id
            ORDER BY ri.id DESC
        ");
        while ($r = $returns->fetch_assoc()) {
            echo "<tr>
                    <td>{$r['id']}</td>
                    <td>{$r['invoice_id']}</td>
                    <td>{$r['name']}</td>
                    <td>{$r['return_quantity']}</td>
                    <td>{$r['refund_amount']}</td>
                    <td>{$r['reason']}</td>
                    <td>{$r['notes']}</td>
                    <td>{$r['status']}</td>
                  </tr>";
        }
        ?>
    </tbody>
</table>

<script>
$(document).ready(function(){

    // Search invoice via AJAX
    $('#searchInvoice').click(function(){
        const invoice_id = $('#invoice_id').val();
        if(invoice_id === '') return alert('Enter Invoice ID');

        $.ajax({
            url: 'fetch_invoice_products.php',
            method: 'GET',
            data: { invoice_id: invoice_id },
            success: function(response){
                $('#invoiceProducts').html(response);
            }
        });
    });

    // Submit return via AJAX
    $('#returnForm').submit(function(e){
        e.preventDefault();
        $.ajax({
            url: 'process_return_ajax.php',
            method: 'POST',
            data: $(this).serialize(),
            success: function(response){
                alert('Return processed successfully!');
                location.reload(); // reload page to update returns list
            }
        });
    });

});
</script>
</body>
</html>
