
<!----------------------------------Login------------------------------------>
<?php
include 'db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে
$userId = $_SESSION['user_id'];


$isAdmin = ($_SESSION['role'] == 'admin');

?>

<!---------------------------------কন্টেন------------------------------------>

<?php

if (!isset($_SESSION['user_id']) || !isset($_SESSION['role'])) {
    die("User not logged in or role missing.");
}

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];

// Initialize variables for totals
$total_today = 0;
$total_last_7_days = 0;
$total_last_30_days = 0;

// Prepare base queries with or without user_id filter depending on role
if ($role === 'admin') {
    // Admin: no user_id filter
    $query_today = "SELECT SUM(grand_total) AS total_today FROM sales WHERE DATE(created_at) = CURDATE()";
    $query_7_days = "SELECT SUM(grand_total) AS total_last_7_days FROM sales WHERE created_at >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)";
    $query_30_days = "SELECT SUM(grand_total) AS total_last_30_days FROM sales WHERE created_at >= DATE_SUB(CURDATE(), INTERVAL 100000 DAY)";

    // Today
    $result_today = $con->query($query_today);
    if ($row_today = $result_today->fetch_assoc()) {
        $total_today = $row_today['total_today'] ?? 0;
    }
    // Last 7 days
    $result_7_days = $con->query($query_7_days);
    if ($row_7_days = $result_7_days->fetch_assoc()) {
        $total_last_7_days = $row_7_days['total_last_7_days'] ?? 0;
    }
    // Last 30 days
    $result_30_days = $con->query($query_30_days);
    if ($row_30_days = $result_30_days->fetch_assoc()) {
        $total_last_30_days = $row_30_days['total_last_30_days'] ?? 0;
    }

} else {
    // Normal user: filter by user_id, use prepared statements
    $query_today = "SELECT SUM(grand_total) AS total_today FROM sales WHERE DATE(created_at) = CURDATE() AND user_id = ?";
    $stmt_today = $con->prepare($query_today);
    $stmt_today->bind_param("i", $user_id);
    $stmt_today->execute();
    $result_today = $stmt_today->get_result();
    if ($row_today = $result_today->fetch_assoc()) {
        $total_today = $row_today['total_today'] ?? 0;
    }
    $stmt_today->close();

    $query_7_days = "SELECT SUM(grand_total) AS total_last_7_days FROM sales WHERE created_at >= DATE_SUB(CURDATE(), INTERVAL 7 DAY) AND user_id = ?";
    $stmt_7_days = $con->prepare($query_7_days);
    $stmt_7_days->bind_param("i", $user_id);
    $stmt_7_days->execute();
    $result_7_days = $stmt_7_days->get_result();
    if ($row_7_days = $result_7_days->fetch_assoc()) {
        $total_last_7_days = $row_7_days['total_last_7_days'] ?? 0;
    }
    $stmt_7_days->close();

    $query_30_days = "SELECT SUM(grand_total) AS total_last_30_days FROM sales WHERE created_at >= DATE_SUB(CURDATE(), INTERVAL 30 DAY) AND user_id = ?";
    $stmt_30_days = $con->prepare($query_30_days);
    $stmt_30_days->bind_param("i", $user_id);
    $stmt_30_days->execute();
    $result_30_days = $stmt_30_days->get_result();
    if ($row_30_days = $result_30_days->fetch_assoc()) {
        $total_last_30_days = $row_30_days['total_last_30_days'] ?? 0;
    }
    $stmt_30_days->close();
}

// Fetch total Cost amount
$sql_total = "SELECT SUM(tk) as total_tk FROM cost";
$result_total = $con->query($sql_total);
if ($result_total->num_rows > 0) {
    $total_tk = $result_total->fetch_assoc()['total_tk'];
}


// Close the database connection
mysqli_close($con);
?>
