<!----------------------------------Login------------------------------------>
<?php
include 'php/db_connection.php';
include 'sidebar.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে
$userId = $_SESSION['user_id'];


$isAdmin = ($_SESSION['role'] == 'admin');


$con->set_charset("utf8mb4");

// গ্রাহকের ID চেক
if (!isset($_GET['customer_id'])) {
    echo "Invalid customer ID.";
    exit;
}

$customer_id = intval($_GET['customer_id']);

// Fetch গ্রাহকের নাম, ফোন, total_grand, collected from sales
$sql = "
SELECT 
    customer_name,
    customer_phone,
    SUM(grand_total) AS total_grand,
    SUM(discount) AS discount_grand,
    SUM(collected) AS collected_from_sales
FROM sales
WHERE customer_id = $customer_id
GROUP BY customer_id
";
$result = $con->query($sql);
$sales_data = $result->fetch_assoc();

// Fetch due_collections এর মোট পরিশোধ
$sql2 = "
SELECT SUM(collected_amount) AS collected_from_due_collections
FROM due_collections
WHERE customer_id = $customer_id
";
$result2 = $con->query($sql2);
$due_data = $result2->fetch_assoc();

// মান নিরাপদ করা
$total_grand = $sales_data['total_grand'] ?? 0;
$discount_grand= $sales_data['discount_grand'] ?? 0;
$collected_from_sales = $sales_data['collected_from_sales'] ?? 0;
$collected_from_due_collections = $due_data['collected_from_due_collections'] ?? 0;

// মোট পরিশোধ এবং বাকি
$total_collected = $collected_from_sales + $collected_from_due_collections;
$total_due = $total_grand - $total_collected - $discount_grand;
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <title>Due Payment</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: #f5f7fa;
        }
        .payment-card {
            max-width: 600px;
            margin: 30px auto;
            padding: 25px;
            background: white;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .payment-card h3 {
            color: #333;
            margin-bottom: 20px;
        }
        .payment-card label {
            font-weight: 500;
        }
        .summary-box {
            background: #f0f4f8;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="payment-card">

        <h3>Due Payment Name: <?= htmlspecialchars($sales_data['customer_name']) ?> <br> <small>Phone:<?= htmlspecialchars($sales_data['customer_phone']) ?></small></h3>

        <div class="summary-box">
            <p><strong>Total Purchase:</strong> <?= number_format($total_grand, 2) ?>৳</p>
            <p><strong>Discount_grand:</strong> <?= number_format($discount_grand, 2) ?>৳</p>
            <p><strong>Total Paid:</strong> <?= number_format($total_collected, 2) ?>৳</p>
            <p><strong>Remaining Due:</strong> <span class="text-danger"><?= number_format($total_due, 2) ?>৳</span></p>
        </div>

        <!-- ফর্ম: নতুন কালেকশন -->
        <form method="POST" action="save_due.php">
            <input type="hidden" name="customer_id" value="<?= $customer_id ?>">
            <input type="hidden" name="collected_by" value="<?= $userId ?>">

            <div class="mb-3">
                <label for="amount">New Collection Amount (৳):</label>
                <input type="number" name="collected_amount" class="form-control" id="amount" step="0.01" min="0" max="<?= $total_due ?>" required>
            </div>

            <button type="submit" class="btn btn-primary w-100">Submit Payment</button>
        </form>

    </div>
</div>

<!-- Bootstrap JS (optional but useful) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>





