<!----------------------------------Login------------------------------------>
<?php
include 'php/db_connection.php';

// শুধুমাত্র লগইন করা ইউজার পেজ দেখতে পারবে
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role']; // ✅ এখানে role সেভ করা হচ্ছে
$userId = $_SESSION['user_id'];


$isAdmin = ($_SESSION['role'] == 'admin');

?>

<!---------------------------------কন্টেন------------------------------------>
<?php

// সেশন থেকে ইউজার আইডি ও রোল বের করি
$user_id = $_SESSION['user_id'] ?? null;
$role = $_SESSION['role'] ?? 'user';

// প্রতি পেজে কয়টি রেকর্ড দেখাবো
$records_per_page = 5;

// Admin হলে সব রেকর্ড, User হলে user_id অনুযায়ী
$whereClause = ($role === 'admin') ? "" : "WHERE user_id = $user_id";

// মোট রেকর্ড বের করি
$total_sql = "SELECT COUNT(*) FROM sales $whereClause";
$total_result = $con->query($total_sql);
$total_row = $total_result->fetch_row();
$total_records = $total_row[0];

// মোট কতটি পেজ দরকার
$total_pages = ceil($total_records / $records_per_page);

// কারেন্ট পেজ নাম্বার
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$start_from = ($page - 1) * $records_per_page;

// sales রেকর্ড আনা
$sql = "SELECT id, customer_name, customer_address, deposit, discount, grand_total, created_at 
        FROM sales 
        $whereClause
        ORDER BY created_at DESC 
        LIMIT $start_from, $records_per_page";
$result = $con->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Recent Sales</title>
    <link rel="stylesheet" href="style.css">
    <style>
        /* Pagination Styling */
        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }
        .pagination a {
            margin: 0 5px;
            padding: 8px 16px;
            text-decoration: none;
            color: #007bff;
            border: 1px solid #007bff;
            border-radius: 5px;
            font-size: 16px;
        }
        .pagination a:hover {
            background-color: #007bff;
            color: white;
        }
        .pagination .active {
            background-color: #007bff;
            color: white;
            padding: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        td {
            background-color: #fafafa;
        }
        .action-button {
            padding: 5px 10px;
            text-decoration: none;
            background-color: #007bff;
            color: white;
            border-radius: 5px;
            font-size: 14px;
        }
        .action-button:hover {
            background-color: #0056b3;
        }
        h5 {
            text-align: center;
            border-bottom: 2px solid rgb(84, 85, 87);
            padding: 10px;
        }
    </style>
</head>
<body>
    <h5>Recent Sales</h5>
    <a href="index.php">Home</a>

    <table>
        <tr>
            <th>ID</th>
            <th>Customer Name</th>
            <th>Customer Address</th>
            <th>Deposit</th>
            <th>Discount</th>
            <th>Grand Total</th>
            <th>Date</th>
            <th>Action</th>
        </tr>

        <?php if ($result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?php echo $row['id']; ?></td>
                    <td><?php echo htmlspecialchars($row['customer_name']); ?></td>
                    <td><?php echo htmlspecialchars($row['customer_address']); ?></td>
                    <td><?php echo number_format($row['deposit'], 2); ?></td>
                    <td><?php echo number_format($row['discount'], 2); ?></td>
                    <td><?php echo number_format($row['grand_total'], 2); ?></td>
                    <td><?php echo date('Y-m-d', strtotime($row['created_at'])); ?></td>
                    <td>
                        <button class="action-button" onclick="window.open('invose_print.php?id=<?php echo $row['id']; ?>', '_blank')">Print</button>
                    </td>
                </tr>
            <?php endwhile; ?>
        <?php else: ?>
            <tr>
                <td colspan="8">No recent sales found</td>
            </tr>
        <?php endif; ?>
    </table>

    <!-- Pagination Links -->
    <div class="pagination">
        <?php if ($page > 1): ?>
            <a href="?page=<?php echo $page - 1; ?>">Prev</a>
        <?php endif; ?>

        <span class="active">Page <?php echo $page; ?> of <?php echo $total_pages; ?></span>

        <?php if ($page < $total_pages): ?>
            <a href="?page=<?php echo $page + 1; ?>">Next</a>
        <?php endif; ?>
    </div>

    <?php $con->close(); ?>
</body>
</html>
