<?php
include 'db_connection.php';?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Sale</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-5">
    <h2>Create Sale</h2>
    <form method="post" action="create_sale.php">
        <!-- Customer Selection -->
        <div class="form-group">
            <label for="customer_name">Customer Name:</label>
            <select name="customer_name" id="customer_name" class="form-control">
                <option value="">Select Customer</option>
                <?php while ($customer = $customers->fetch_assoc()): ?>
                    <option value="<?= htmlspecialchars($customer['customer_name']) ?>"><?= htmlspecialchars($customer['customer_name']) ?></option>
                <?php endwhile; ?>
                <option value="guest">Guest Customer</option>
            </select>
        </div>

        <!-- Guest Info -->
        <div id="guest-info" style="display:none;">
            <div class="form-group">
                <label for="guest_name">Guest Name:</label>
                <input type="text" id="guest_name" name="guest_name" class="form-control">
            </div>
            <div class="form-group">
                <label for="guest_address">Guest Address:</label>
                <input type="text" id="guest_address" name="guest_address" class="form-control">
            </div>
        </div>

        <!-- Product Selection -->
        <div class="form-group">
            <label for="productSelect">Select Product:</label>
            <select id="productSelect" class="form-control">
                <option value="">Select a product</option>
                <?php while ($product = $products_cat->fetch_assoc()): ?>
                    <option value="<?= htmlspecialchars($product['Product_id']) ?>" 
                            data-description="<?= htmlspecialchars($product['Product_name']) ?>" 
                            data-price="<?= htmlspecialchars($product['price']) ?>" 
                            data-purchase_price="<?= htmlspecialchars($product['purchase_price']) ?>">
                        <?= htmlspecialchars($product['Product_name']) ?> - $<?= htmlspecialchars($product['price']) ?>
                    </option>
                <?php endwhile; ?>
            </select>
            <button type="button" class="btn btn-primary mt-2" onclick="addSelectedProduct()">Add Product</button>
        </div>

        <!-- Product List -->
        <table class="table" id="productList">
            <thead>
            <tr>
                <th>Product ID</th>
                <th>Description</th>
                <th>Quantity</th>
                <th>Price</th>
                <th>Total</th>
                <th>Actions</th>
            </tr>
            </thead>
            <tbody></tbody>
        </table>

        <!-- Payment Details -->
        <div class="form-group">
            <label for="discount">Discount:</label>
            <input type="number" name="discount" id="discount" class="form-control" onchange="calculateGrandTotal()">
        </div>
        <div class="form-group">
            <label for="grand_total">Grand Total:</label>
            <input type="text" name="grand_total" id="grand_total" class="form-control" readonly>
        </div>
        <button type="submit" name="createSale" class="btn btn-primary">Create Sale</button>
    </form>
</div>
<script src="js/scripts.js"></script>
</body>
</html>
