<?php
session_start();
include 'php/db_connection.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$userName = $_SESSION['user_name'];
$role = $_SESSION['role'];
$userId = $_SESSION['user_id'];
$isAdmin = ($role == 'admin');

// ---------------- Filter ----------------
$stock_limit = isset($_GET['stock_limit']) ? intval($_GET['stock_limit']) : 10;

// ---------------- Pagination ----------------
$limit = 10; // rows per page
$page = isset($_GET['page']) ? max(1,intval($_GET['page'])) : 1;
$offset = ($page - 1) * $limit;

// Total products for pagination
$totalResult = $con->query("
    SELECT COUNT(*) as total 
    FROM (
        SELECT Product_id 
        FROM product 
        GROUP BY Product_id 
        HAVING SUM(Quantity) <= $stock_limit
    ) as t
");
$totalRow = $totalResult->fetch_assoc();
$total_pages = ceil($totalRow['total'] / $limit);

// Fetch low stock products with pagination
$products = $con->query("
    SELECT Product_id, name, SUM(Quantity) as total_quantity, price 
    FROM product 
    GROUP BY Product_id, name, price
    HAVING total_quantity <= $stock_limit
    ORDER BY total_quantity ASC
    LIMIT $limit OFFSET $offset
");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Stock Alerts</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body { padding: 0px; }
        .low-stock { background-color: #f8d7da; }
        .table thead th, .table tbody td { text-align: center; }
        .pagination { justify-content: center; }
    </style>
        <?php include 'sidebar.php'; ?>
</head>
<body>


    <div class="container">
        <h2 class="mb-4">Stock Alerts</h2>

        <!-- Filter Form -->
        <form method="get" class="form-inline mb-3">
            <label for="stock_limit" class="mr-2">Show products with stock ≤ </label>
            <input type="number" name="stock_limit" id="stock_limit" class="form-control mr-2" value="<?= $stock_limit ?>" min="1">
            <button type="submit" class="btn btn-primary">Filter</button>
        </form>

        <!-- Stock Table -->
        <table class="table table-bordered table-striped">
            <thead class="thead-dark">
                <tr>
                    <th>Product ID</th>
                    <th>Name</th>
                    <th>Total Quantity</th>
                    <th>Price</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php if($products->num_rows > 0): ?>
                    <?php while($product = $products->fetch_assoc()): ?>
                        <tr class="low-stock">
                            <td><?= htmlspecialchars($product['Product_id']) ?></td>
                            <td><?= htmlspecialchars($product['name']) ?></td>
                            <td><?= $product['total_quantity'] ?></td>
                            <td><?= number_format($product['price'],2) ?></td>
                            <td>
                                <a href="edit_product.php?id=<?= $product['Product_id'] ?>" class="btn btn-sm btn-primary">Restock</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5">No low stock products.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <!-- Pagination -->
        <nav>
            <ul class="pagination">
                <?php if($page > 1): ?>
                    <li class="page-item">
                        <a class="page-link" href="?stock_limit=<?= $stock_limit ?>&page=<?= $page-1 ?>">Previous</a>
                    </li>
                <?php endif; ?>
                <?php for($i=1; $i<=$total_pages; $i++): ?>
                    <li class="page-item <?= ($i==$page)?'active':'' ?>">
                        <a class="page-link" href="?stock_limit=<?= $stock_limit ?>&page=<?= $i ?>"><?= $i ?></a>
                    </li>
                <?php endfor; ?>
                <?php if($page < $total_pages): ?>
                    <li class="page-item">
                        <a class="page-link" href="?stock_limit=<?= $stock_limit ?>&page=<?= $page+1 ?>">Next</a>
                    </li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>
</body>
</html>
